VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Timer Utilities Test Program"
   ClientHeight    =   4965
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   10170
   LinkTopic       =   "Form1"
   ScaleHeight     =   4965
   ScaleWidth      =   10170
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton StopElapsedTimerButton 
      Caption         =   "Stop elapsed timer"
      Enabled         =   0   'False
      Height          =   495
      Left            =   8400
      TabIndex        =   17
      Top             =   3480
      Width           =   1575
   End
   Begin VB.CommandButton StartElapsedTimerButton 
      Caption         =   "Start elapsed timer"
      Height          =   495
      Left            =   8400
      TabIndex        =   16
      Top             =   3000
      Width           =   1575
   End
   Begin VB.Frame Interval2 
      Caption         =   "Timer 2"
      Height          =   4575
      Left            =   4320
      TabIndex        =   19
      Top             =   240
      Width           =   3735
      Begin VB.PictureBox Picture1 
         BorderStyle     =   0  'None
         Height          =   4215
         Left            =   240
         ScaleHeight     =   4215
         ScaleWidth      =   3375
         TabIndex        =   29
         Top             =   240
         Width           =   3375
         Begin VB.CommandButton StopTimerButton2 
            Caption         =   "Stop timer"
            Enabled         =   0   'False
            Height          =   495
            Left            =   1920
            TabIndex        =   15
            Top             =   3720
            Width           =   1455
         End
         Begin VB.CommandButton StartTimerButton2 
            Caption         =   "Start timer"
            Height          =   495
            Left            =   240
            TabIndex        =   14
            Top             =   3720
            Width           =   1455
         End
         Begin VB.TextBox FirstIntervalValue2 
            Height          =   285
            Left            =   480
            TabIndex        =   8
            Text            =   "1"
            Top             =   1200
            Width           =   2175
         End
         Begin VB.OptionButton FirstDateTimeOpt2 
            Caption         =   "Date/time"
            Height          =   195
            Left            =   600
            TabIndex        =   11
            Top             =   2040
            Width           =   1335
         End
         Begin VB.TextBox IntervalValue2 
            Height          =   285
            Left            =   480
            TabIndex        =   12
            Text            =   "0"
            Top             =   2640
            Width           =   1095
         End
         Begin VB.OptionButton FirstSecondsOpt2 
            Caption         =   "Seconds"
            Height          =   195
            Left            =   600
            TabIndex        =   9
            Top             =   1560
            Value           =   -1  'True
            Width           =   1455
         End
         Begin VB.OptionButton FirstMillisecondsOpt2 
            Caption         =   "Millisecs"
            Height          =   195
            Left            =   600
            TabIndex        =   10
            Top             =   1800
            Width           =   1575
         End
         Begin VB.CheckBox RandomCheck2 
            Caption         =   "Random"
            Height          =   255
            Left            =   480
            TabIndex        =   13
            Top             =   3120
            Width           =   1575
         End
         Begin VB.Label Label10 
            Alignment       =   1  'Right Justify
            Caption         =   "Average interval (millisecs)"
            Height          =   375
            Left            =   240
            TabIndex        =   40
            Top             =   360
            Width           =   1575
         End
         Begin VB.Label Label9 
            Alignment       =   1  'Right Justify
            Caption         =   "Event count"
            Height          =   255
            Left            =   240
            TabIndex        =   39
            Top             =   0
            Width           =   1575
         End
         Begin VB.Label Counter2 
            Alignment       =   1  'Right Justify
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            ForeColor       =   &H80000008&
            Height          =   255
            Left            =   1920
            TabIndex        =   36
            Top             =   0
            Width           =   1455
         End
         Begin VB.Label AvgInterval2Label 
            Alignment       =   1  'Right Justify
            BackColor       =   &H80000005&
            Height          =   255
            Left            =   1920
            TabIndex        =   35
            Top             =   360
            Width           =   1455
         End
         Begin VB.Label Label3 
            Caption         =   "First interval"
            Height          =   255
            Left            =   0
            TabIndex        =   32
            Top             =   960
            Width           =   1575
         End
         Begin VB.Label Label2 
            Caption         =   "Repeat interval"
            Height          =   255
            Left            =   0
            TabIndex        =   31
            Top             =   2400
            Width           =   1575
         End
         Begin VB.Label Label1 
            Caption         =   "(Milliseconds)"
            Height          =   255
            Left            =   1800
            TabIndex        =   30
            Top             =   2640
            Width           =   1215
         End
      End
   End
   Begin VB.Frame Interval1 
      Caption         =   "Timer 1"
      Height          =   4575
      Left            =   240
      TabIndex        =   18
      Top             =   240
      Width           =   3735
      Begin VB.PictureBox Picture3 
         BorderStyle     =   0  'None
         Height          =   4215
         Left            =   240
         ScaleHeight     =   4215
         ScaleWidth      =   3375
         TabIndex        =   25
         Top             =   240
         Width           =   3375
         Begin VB.CommandButton StartTimerButton1 
            Caption         =   "Start timer"
            Height          =   495
            Left            =   240
            TabIndex        =   6
            Top             =   3720
            Width           =   1455
         End
         Begin VB.CommandButton StopTimerButton1 
            Caption         =   "Stop timer"
            Enabled         =   0   'False
            Height          =   495
            Left            =   1920
            TabIndex        =   7
            Top             =   3720
            Width           =   1455
         End
         Begin VB.OptionButton FirstDateTimeOpt1 
            Caption         =   "Date/time"
            Height          =   195
            Left            =   600
            TabIndex        =   3
            Top             =   2040
            Width           =   1335
         End
         Begin VB.OptionButton FirstSecondsOpt1 
            Caption         =   "Seconds"
            Height          =   195
            Left            =   600
            TabIndex        =   1
            Top             =   1560
            Value           =   -1  'True
            Width           =   1335
         End
         Begin VB.OptionButton FirstMillisecondsOpt1 
            Caption         =   "Millisecs"
            Height          =   195
            Left            =   600
            TabIndex        =   2
            Top             =   1800
            Width           =   1575
         End
         Begin VB.TextBox FirstIntervalValue1 
            Height          =   285
            Left            =   480
            TabIndex        =   0
            Text            =   "1"
            Top             =   1200
            Width           =   2175
         End
         Begin VB.TextBox IntervalValue1 
            Height          =   285
            Left            =   480
            TabIndex        =   4
            Text            =   "0"
            Top             =   2640
            Width           =   1095
         End
         Begin VB.CheckBox RandomCheck1 
            Caption         =   "Random"
            Height          =   255
            Left            =   480
            TabIndex        =   5
            Top             =   3120
            Width           =   1215
         End
         Begin VB.Label Label8 
            Alignment       =   1  'Right Justify
            Caption         =   "Average interval (millisecs)"
            Height          =   375
            Left            =   240
            TabIndex        =   38
            Top             =   360
            Width           =   1575
         End
         Begin VB.Label Label6 
            Alignment       =   1  'Right Justify
            Caption         =   "Event count"
            Height          =   255
            Left            =   240
            TabIndex        =   37
            Top             =   0
            Width           =   1575
         End
         Begin VB.Label Counter1 
            Alignment       =   1  'Right Justify
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            ForeColor       =   &H80000008&
            Height          =   255
            Left            =   1920
            TabIndex        =   34
            Top             =   0
            Width           =   1455
         End
         Begin VB.Label AvgInterval1Label 
            Alignment       =   1  'Right Justify
            BackColor       =   &H80000005&
            Height          =   255
            Left            =   1920
            TabIndex        =   33
            Top             =   360
            Width           =   1455
         End
         Begin VB.Label Label7 
            Caption         =   "Repeat interval"
            Height          =   255
            Left            =   0
            TabIndex        =   28
            Top             =   2400
            Width           =   1575
         End
         Begin VB.Label Label4 
            Caption         =   "First interval"
            Height          =   255
            Left            =   0
            TabIndex        =   27
            Top             =   960
            Width           =   1575
         End
         Begin VB.Label Label5 
            Caption         =   "(Milliseconds)"
            Height          =   255
            Left            =   1800
            TabIndex        =   26
            Top             =   2640
            Width           =   1215
         End
      End
   End
   Begin VB.Label ElapsedTimeLabel 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   8400
      TabIndex        =   24
      Top             =   2640
      Width           =   1575
   End
   Begin VB.Label ValueLabel 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   3
      Left            =   8640
      TabIndex        =   23
      Top             =   1320
      Width           =   1335
   End
   Begin VB.Label ValueLabel 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   2
      Left            =   8640
      TabIndex        =   22
      Top             =   960
      Width           =   1335
   End
   Begin VB.Label ValueLabel 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   1
      Left            =   8640
      TabIndex        =   21
      Top             =   600
      Width           =   1335
   End
   Begin VB.Label ValueLabel 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Index           =   0
      Left            =   8640
      TabIndex        =   20
      Top             =   240
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'================================================================================
' Description
'================================================================================
'
'

'================================================================================
' Interfaces
'================================================================================

'================================================================================
' Events
'================================================================================

'================================================================================
' Constants
'================================================================================

'================================================================================
' Enums
'================================================================================

Public Enum Comparison
    Greater
    Less
    Equal
End Enum

'================================================================================
' Types
'================================================================================

'================================================================================
' Member variables
'================================================================================

Private mCounter1 As Long
Private mCounter2 As Long
Private mTotalElapsed1 As Double
Private mTotalElapsed2 As Double

Private WithEvents mTimer1 As IntervalTimer
Attribute mTimer1.VB_VarHelpID = -1
Private WithEvents mTimer2 As IntervalTimer
Attribute mTimer2.VB_VarHelpID = -1

Private mFirstIntervalUnit1 As ExpiryTimeUnits
Private mFirstIntervalUnit2 As ExpiryTimeUnits

Private WithEvents mTimerList As TimerList
Attribute mTimerList.VB_VarHelpID = -1
Private mTimerListItems(3) As TimerListItem

Private mElapsedTimer As ElapsedTimer

Private mElapsedTimer1 As ElapsedTimer
Private mElapsedTimer2 As ElapsedTimer

'================================================================================
' Form Event Handlers
'================================================================================

Private Sub Form_Initialize()
InitCommonControls
End Sub

Private Sub Form_Load()
Set mElapsedTimer1 = New ElapsedTimer
Set mElapsedTimer2 = New ElapsedTimer

Set mTimerList = TimerUtils2.createTimerList(200, False)
mTimerList.StartTiming

ValueLabel(0).Caption = 0
ValueLabel(1).Caption = 0
ValueLabel(2).Caption = 0
ValueLabel(3).Caption = 0

mFirstIntervalUnit1 = ExpiryTimeUnitSeconds
mFirstIntervalUnit2 = ExpiryTimeUnitSeconds
End Sub

'================================================================================
' XXXX Interface Members
'================================================================================

'================================================================================
' Form Control Event Handlers
'================================================================================

Private Sub FirstDateTimeOpt1_Click()
mFirstIntervalUnit1 = ExpiryTimeUnitDateTime
If Not IsDate(FirstIntervalValue1) Then
    FirstIntervalValue1.SetFocus
    FirstIntervalValue1.SelStart = 0
    FirstIntervalValue1.SelLength = Len(FirstIntervalValue1)
End If
End Sub

Private Sub FirstDateTimeOpt2_Click()
mFirstIntervalUnit2 = ExpiryTimeUnitDateTime
If Not IsDate(FirstIntervalValue2) Then
    FirstIntervalValue2.SetFocus
    FirstIntervalValue2.SelStart = 0
    FirstIntervalValue2.SelLength = Len(FirstIntervalValue2)
End If
End Sub

Private Sub FirstIntervalValue1_Validate(Cancel As Boolean)
Select Case mFirstIntervalUnit1
Case ExpiryTimeUnitDateTime
    If Not IsDate(FirstIntervalValue1) Then Cancel = True
    If CDate(FirstIntervalValue1) <= Now Then Cancel = True
Case ExpiryTimeUnitSeconds
    If Not IsNumeric(FirstIntervalValue1) Then Cancel = True
Case ExpiryTimeUnitMilliseconds
    If Not IsNumeric(FirstIntervalValue1) Then Cancel = True
End Select
End Sub

Private Sub FirstIntervalValue2_Validate(Cancel As Boolean)
Select Case mFirstIntervalUnit2
Case ExpiryTimeUnitDateTime
    If Not IsDate(FirstIntervalValue2) Then Cancel = True
    If CDate(FirstIntervalValue2) <= Now Then Cancel = True
Case ExpiryTimeUnitSeconds
    If Not IsNumeric(FirstIntervalValue2) Then Cancel = True
Case ExpiryTimeUnitMilliseconds
    If Not IsNumeric(FirstIntervalValue2) Then Cancel = True
End Select
End Sub

Private Sub FirstMillisecondsOpt1_Click()
mFirstIntervalUnit1 = ExpiryTimeUnitMilliseconds
If Not IsNumeric(FirstIntervalValue1) Then
    FirstIntervalValue1.SetFocus
    FirstIntervalValue1.SelStart = 0
    FirstIntervalValue1.SelLength = Len(FirstIntervalValue1)
End If
End Sub

Private Sub FirstMilliSecondsOpt2_Click()
mFirstIntervalUnit2 = ExpiryTimeUnitMilliseconds
If Not IsNumeric(FirstIntervalValue2) Then
    FirstIntervalValue2.SetFocus
    FirstIntervalValue2.SelStart = 0
    FirstIntervalValue2.SelLength = Len(FirstIntervalValue2)
End If
End Sub

Private Sub FirstSecondsOpt1_Click()
mFirstIntervalUnit1 = ExpiryTimeUnitSeconds
If Not IsNumeric(FirstIntervalValue1) Then
    FirstIntervalValue1.SetFocus
    FirstIntervalValue1.SelStart = 0
    FirstIntervalValue1.SelLength = Len(FirstIntervalValue1)
End If
End Sub

Private Sub FirstSecondsOpt2_Click()
mFirstIntervalUnit2 = ExpiryTimeUnitSeconds
If Not IsNumeric(FirstIntervalValue2) Then
    FirstIntervalValue2.SetFocus
    FirstIntervalValue2.SelStart = 0
    FirstIntervalValue2.SelLength = Len(FirstIntervalValue2)
End If
End Sub

Private Sub IntervalValue1_Validate(Cancel As Boolean)
If Not IsNumeric(IntervalValue1) Then Cancel = True
End Sub

Private Sub IntervalValue2_Validate(Cancel As Boolean)
If Not IsNumeric(IntervalValue2) Then Cancel = True
End Sub

Private Sub StartElapsedTimerButton_Click()
Set mElapsedTimer = New ElapsedTimer
mElapsedTimer.StartTiming
StartElapsedTimerButton.Enabled = False
StopElapsedTimerButton.Enabled = True
End Sub

Private Sub StartTimerButton1_Click()
If mFirstIntervalUnit1 = ExpiryTimeUnitDateTime And _
    CDate(FirstIntervalValue1) <= Now _
Then
    FirstIntervalValue1.SetFocus
    FirstIntervalValue1.SelStart = 0
    FirstIntervalValue1.SelLength = Len(FirstIntervalValue1)
    Exit Sub
End If
    
mCounter1 = 0
mTotalElapsed1 = 0
StopTimerButton1.Enabled = True
StartTimerButton1.Enabled = False
Set mTimer1 = createIntervalTimer(FirstIntervalValue1, _
                        mFirstIntervalUnit1, _
                        IntervalValue1, _
                        IIf(RandomCheck1 = vbChecked, True, False))
mElapsedTimer1.StartTiming
mTimer1.startTimer
End Sub

Private Sub StartTimerButton2_Click()
If mFirstIntervalUnit2 = ExpiryTimeUnitDateTime And _
    CDate(FirstIntervalValue2) <= Now _
Then
    FirstIntervalValue2.SetFocus
    FirstIntervalValue2.SelStart = 0
    FirstIntervalValue2.SelLength = Len(FirstIntervalValue2)
    Exit Sub
End If
    
mCounter2 = 0
mTotalElapsed2 = 0
StopTimerButton2.Enabled = True
StartTimerButton2.Enabled = False
Set mTimer2 = createIntervalTimer(FirstIntervalValue2, _
                        mFirstIntervalUnit2, _
                        IntervalValue2, _
                        IIf(RandomCheck2 = vbChecked, True, False))
mTimer2.startTimer
mElapsedTimer2.StartTiming
End Sub

Private Sub StopElapsedTimerButton_Click()
Dim elapsedTime As Double
elapsedTime = mElapsedTimer.ElapsedTimeMicroseconds
ElapsedTimeLabel.Caption = Format(elapsedTime / 1000000, "#.######") & "s"
StartElapsedTimerButton.Enabled = True
StopElapsedTimerButton.Enabled = False
End Sub

Private Sub StopTimerButton1_Click()
StopTimerButton1.Enabled = False
StartTimerButton1.Enabled = True
mTimer1.stopTimer
End Sub

Private Sub StopTimerButton2_Click()
StopTimerButton2.Enabled = False
StartTimerButton2.Enabled = True
mTimer2.stopTimer
End Sub

'================================================================================
' mTestClass1 Event Handlers
'================================================================================

Private Sub mTimer1_TimerExpired()
mCounter1 = mCounter1 + 1
Counter1.Caption = CStr(mCounter1)
mTotalElapsed1 = mTotalElapsed1 + mElapsedTimer1.ElapsedTimeMicroseconds
AvgInterval1Label.Caption = Format(mTotalElapsed1 / (1000 * mCounter1), "0.000")
mElapsedTimer1.StartTiming
If Not mTimer1.RepeatNotifications Then
    StartTimerButton1.Enabled = True
    StopTimerButton1.Enabled = False
End If

generateData
End Sub

'================================================================================
' mTestClass2 Event Handlers
'================================================================================

Private Sub mTimer2_TimerExpired()
mCounter2 = mCounter2 + 1
Counter2.Caption = CStr(mCounter2)
mTotalElapsed2 = mTotalElapsed2 + mElapsedTimer2.ElapsedTimeMicroseconds
AvgInterval2Label.Caption = Format(mTotalElapsed2 / (1000 * mCounter2), "0.000")
mElapsedTimer2.StartTiming
If Not mTimer2.RepeatNotifications Then
    StartTimerButton2.Enabled = True
    StopTimerButton2.Enabled = False
End If

generateData
End Sub

'================================================================================
' mTimerList Event Handlers
'================================================================================

Private Sub mTimerList_ItemExpired(ByVal Item As TimerUtils2.TimerListItem)
Dim entryData As TimerItemData
Set entryData = Item.Data
Select Case entryData.Relative
Case Greater
    ValueLabel(entryData.Index).BackColor = vbWhite
    ValueLabel(entryData.Index).ForeColor = vbBlue
Case Less
    ValueLabel(entryData.Index).BackColor = vbWhite
    ValueLabel(entryData.Index).ForeColor = vbRed
Case Equal
    ValueLabel(entryData.Index).BackColor = vbWhite
    ValueLabel(entryData.Index).ForeColor = vbGreen
End Select
Set mTimerListItems(entryData.Index) = Nothing
End Sub

'================================================================================
' Properties
'================================================================================

'================================================================================
' Methods
'================================================================================

'================================================================================
' Helper Functions
'================================================================================

Private Sub generateData()
Dim Index As Long
Dim newval As Long
Dim Data As TimerItemData
Dim prevTimerListItem As TimerListItem

Index = Int(1000 * Rnd) Mod 4
newval = ValueLabel(Index).Caption + Int(11 * Rnd - 5)

Set Data = New TimerItemData
Data.Index = Index
If newval > ValueLabel(Index).Caption Then
    Data.Relative = Comparison.Greater
    ValueLabel(Index).BackColor = vbBlue
    ValueLabel(Index).ForeColor = vbWhite
ElseIf newval < ValueLabel(Index).Caption Then
    Data.Relative = Comparison.Less
    ValueLabel(Index).BackColor = vbRed
    ValueLabel(Index).ForeColor = vbWhite
Else
    Data.Relative = Comparison.Equal
    ValueLabel(Index).BackColor = vbGreen
    ValueLabel(Index).ForeColor = vbWhite
End If

Set prevTimerListItem = mTimerListItems(Index)
Set mTimerListItems(Index) = mTimerList.Add(Data, 500, ExpiryTimeUnitMilliseconds)
If Not prevTimerListItem Is Nothing Then
    mTimerList.Remove prevTimerListItem
End If

ValueLabel(Index).Caption = newval
End Sub


